# Charity Notes 11: 迈蒙尼德和阿舍尔的呼吁慈善理论

这节课将介绍中世纪两位学者 Maimondies (Rambam) 和 Jacob Ben Asher (“Tur”) 如何鼓励他们的犹太同胞慷慨和慈善。

## 迈蒙尼德的哲学方法

迈蒙尼德采取了更为==哲学==的方法，即**诫命的重要性在于它包含了给予者的教育元素，这是对接受者的实际帮助**。对于迈蒙尼德来说，慈善事业不仅是为了帮助穷人，也是为了将接受者变成一个更慷慨，仁慈，善良的个体。

他评论了Avot 3的一个片段，强调**行为的重复**，而不是他们的伟大“善行的次数”，也不是“善行的伟大”。他把这与一个心理真相联系在一起，只有重复的行为才有可能影响到人的性格。他称之为“a strong acquisition”，我们将其视为对人类性格的“持久影响”。根据行为的伟大，美德并不是出现在人身上，而是根据大量的善行来实现 - 而这确实是**美德通过多次重复善行来实现的**，而不是当一个人从善行中做出一件伟大的事情时。

请注意他赎回俘虏和捐赠的例子 - 人们可以清楚地看到对**捐赠者的影响有多重要** - 而不仅仅是对接受者的帮助。对于迈蒙尼德来说，将捐赠者转化为更敏感和慷慨的个性同样重要。根据他的方法，我们在他的Mishneh Torah中发现试图唤起犹太人对他的犹太同胞的同情并不奇怪。

他在 Mishneh Torah 的第十章的 Law 2写道：

> 所有以色列人和所有依附于他们的人都像兄弟一样说“你们是耶和华你们神的儿女”，如果一个兄弟不会怜悯他的弟兄，他会怜悯他吗？以色列的穷人会向谁抬起眼睛？那些讨厌他们并追求他们的外邦人？！他们的眼睛只看向他们的兄弟。

同样值得注意的是，在法律的开头也发现了对性格特征的强调。**慈善是正义的标志，是亚伯拉罕的种子**。显然，对于迈蒙尼德来说，仅仅给慈善机构是不够的，他希望人们应该**给予正确的感受，慷慨和善良**。他似乎用==两种策略==来唤起犹太人的同情和慷慨的精神 

1. 一个是“羞辱”他或她，因为没有这些特征的人被怀疑不是犹太人（亚伯拉罕的后裔）而是异教徒和偶像崇拜者。
2. 第二个是通过画一幅关于这个可怜的犹太人的戏剧性画面，这个犹太人无处可转，只能转向他的一个弟兄，他的犹太同胞。<u>他在这里试图在社区内唤起同情和团结的精神。</u>



## Jacob b. Asher 的方法

与迈蒙尼德形成鲜明对比的是 Tur 似乎主要想让犹太人慷慨 - 做慈善行为。他知道Mishneh Torah中的迈蒙尼德章节并从中大量借用，但是他的目的是引起对同伴的同情。这种==完全关注底线==的方法似乎来自于塔木德（Bava Batra 10b），人们可以找到各种策略来说服犹太人慷慨。

他认为**给予最重要的（paramount）行为，而不是行为背后的动机**！

在 Yore Deah siman 247 中，Jacob(Tur) 转向犹太人 - 说你总是要求上帝给你财富来留意你的哭泣，你也必须倾听穷人的呼声，因为穷人与上帝亲近上帝听他们。然后，他又增加了另一种务实的论证 - 由于人类不断变化的财富而值得你付出慈善的代价 - 财富之轮不断旋转。然后，他再提出另一个论点（248），称为“**存款理论**” - 记住你的钱实际上并不是你的钱只是上帝的贷款，如果你不遵守上帝的意愿并且也用它来满足穷人的需要你就不能指望你将保留你的财富。最后他最强大的部分（249）是：从纯粹的投资角度来看，这是值得慷慨的 - 因为只有通过给予慈善而不会失去财富才能获得财富！

强调慈善事业的效用与迈蒙尼德的方法截然不同。这更加引人注目的是，正如我们上面提到的那样，雅各布在他的待遇中完全忽视了迈蒙尼德的做法，这种做法试图在其中引起同情和慷慨的感觉。



## 两者比较

我们在这里看到了两种截然不同的方法：哲学家迈蒙尼德和塔木德主义者雅各布的方法。

1. 对于迈蒙尼德而言，仅仅给予一个人不得不以适当的方式给予，这种方式会影响到人的性格，这样他就会变得更加慷慨和敏感。

2. 如果犹太人为慈善贡献了，雅各布非常高兴，这一最终结果对他来说已经足够了。因此，他利用一切可能的论据来说服犹太人给予。



## 两位学者的传记细节

### 迈蒙尼德

我们接下来介绍这两位学者的一些传记细节，以及它如何影响他们对慈善事业的处理。

众所周知，迈蒙尼德成长不易。当他还很小的时候，Almohads 入侵了西班牙，这让所有非穆斯林都无法忍受生活。犹太人不得不选择归化，被开除或者死亡。迈蒙尼德的家庭后来移居到了北非。在北非他们也并不容易，因为这个国家是由入侵西班牙的同一个人统治的，所以他们也必须将他们的犹太教隐藏在权威之下。随着时间的推移，这次他们再次将行李打包到以色列之地，最后到达埃及 - 在那里他们找到了一些平静和安静的地方。

他写道：

> 我对我们时代的痛苦，上帝赋予我们的流亡，以及我们被驱逐出世界的一端这一事实感到焦躁不已。(Epilogue to Commentary to Mishneh (c. 1168))
>
> 实际上，我是西班牙最低级的学者之一，他们的王位（或荣耀）在流亡中降低了。因为邪恶的日子和艰辛超越了我们;我们没有住在宁静中，我们努力工作，没有休息。当我们被从一个城市流到另一个城市以及从一个国家流到另一个国家时，我们怎么能澄清这个法。(Hebrew Prologue to Epistle to Yemen (1172))

这些艰辛的旅行至少部分地落后于我们从慈善法律中看到的那种表述：“如果一个兄弟不会同情他的兄弟，他会对他有同情心吗？并且以色列的穷人会抬起他们的眼睛吗？对那些恨他们并追求他们的外邦人来说？**他们的眼睛只看向他们的兄弟们**。“  一个人只有转向他的同胞犹太人。



### 雅各布·本·阿舍尔

关于雅各布·本·阿舍尔，他也四处旅行，从德国到西班牙，但是他在西班牙的境遇显然要好上不少。从他的作品的一个段落（Tur Orah Hayim (way of life) siman 242）来看，他就能自给自足，不需要得到支持。我们从他问父亲关于他吃安息日第三餐的义务的问题中了解到这一点。根据法律规定，穷人可以免除这一餐，因为塔木德说，最好让你的安息日像平日一样（也就是说吃两餐而不是三餐）而不要寻求你同僚的帮助。

很明显，他并不完全是经济独立的。考虑到这一点，我们可以争辩说，他比大多数其他学者更了解穷人的心态。他所理解的是，只要他/她能够将面包带回家并喂养孩子，穷人就愿意原谅所有缺乏敏感性。有了这样的态度，我们就能更好地理解他对说服犹太人给予的**“非理想”方法**。他利用所有可能的论据来激励犹太人给予，包括强调行为对给予者的效用。



whzecomjm
2019年7月4日